use michigan_unemployment.dta, clear

gen ym = ym(year, month)
tsset ym, m


capture drop dunrate
gen dunrate = f3.unrate - unrate


// Bhandari, Borovicka & Ho method (Appendix C.1)

gen a = 0.15 
gen sigmatb = 2*a/(invnormal(1-more/100)-invnormal(less/100))
gen mutb = a-sigmatb*invnormal(1-more/100) 
capture drop rhs
gen rhs = dunrate - l3.mutb

keep if year < 2020




newey mutb l3.mutb rhs if year >= 1990, lag(4)
nlcom _b[rhs]/_b[l3.mutb]

newey mutb l3.mutb rhs if year < 1990, lag(4)
nlcom _b[rhs]/_b[l3.mutb]


newey mutb l3.mutb rhs if year >= 2000, lag(4)
nlcom _b[rhs]/_b[l3.mutb]

newey mutb l3.mutb rhs if year < 2000, lag(4)
nlcom _b[rhs]/_b[l3.mutb]


gen post90 = .
replace post90 = 1 if year >= 1990
replace post90 = 0 if year < 1990
gen pre90 =.
replace pre90 = 1 if year < 1990
replace pre90 = 0 if year >= 1990

gen mutbpost = mutb*post90
gen rhspost = rhs*post90
gen mutbpre = mutb*pre90
gen rhspre = rhs*pre90
newey mutb l3.mutbpre l3.mutbpost rhspost rhspre, lag(4)
nlcom (test1: _b[rhspost]/_b[l3.mutbpost]-_b[rhspre]/_b[l3.mutbpre]), post
