clear all
close all
clc

data = xlsread("ngram_nyt_wp.xlsx","B2:G51");
cpi = data(:,6);
nyt = data(:,4)*100;
wp = data(:,5)*100;
ngram = data(:,1);
ngrams = data(:,2);
inflations = (data(:,3));
% Figure B3 (a)
figure(1)
yyaxis left;
plot(1970:1:2019,(cpi),'k-','LineWidth',2); hold on
% yticks([log(7) log(20) log(55) log(150) log(400)]);
% yticklabels({'7','20','55','150','400'});
ylabel('$\%$','Interpreter','Latex','FontSize',18)
set(gca,'ycolor','k') ;%title('SPF w/o FE','Interpreter','Latex','FontSize',25);
yyaxis right;
plot(1970:1:2019,nyt,'--','Color',[0, 0.4470, 0.7410],'LineWidth',2); hold on
set(gca,'ycolor',[0, 0.4470, 0.7410]) ;%title('SPF w/o FE','Interpreter','Latex','FontSize',25);
% plot(1968.75:0.25:2019.75,X(:,3),':','Color',[0.6350, 0.0780, 0.1840],'LineWidth',1.5); %plot(1968.75:0.25:2019.75,X(:,2),'k-','LineWidth',2)
leg = legend('CPI Inflation US','New York Times','Interpreter','Latex','FontSize',18)
%leg.ItemTokenSize = [18,1];
% xlabel('Year','Interpreter','Latex','FontSize',18);xlim([1970,2020])
ylabel('$\%$','Interpreter','Latex','FontSize',18)
set(gca, 'YTickLabel', num2cell(get(gca, 'YTick')))
grid on
box on
% Figure B3 (b)
figure(2)
yyaxis left;
plot(1970:1:2019,(cpi),'k-','LineWidth',2); hold on
% yticks([log(7) log(20) log(55) log(150) log(400)]);
% yticklabels({'7','20','55','150','400'});
ylabel('$\%$','Interpreter','Latex','FontSize',18)
set(gca,'ycolor','k') ;%title('SPF w/o FE','Interpreter','Latex','FontSize',25);
yyaxis right;
plot(1970:1:2019,wp,'--','Color',[0, 0.4470, 0.7410],'LineWidth',2); hold on
set(gca,'ycolor',[0, 0.4470, 0.7410]) ;%title('SPF w/o FE','Interpreter','Latex','FontSize',25);
% plot(1968.75:0.25:2019.75,X(:,3),':','Color',[0.6350, 0.0780, 0.1840],'LineWidth',1.5); %plot(1968.75:0.25:2019.75,X(:,2),'k-','LineWidth',2)
leg = legend('CPI Inflation US','Washington Post','Interpreter','Latex','FontSize',18)
%leg.ItemTokenSize = [18,1];
% xlabel('Year','Interpreter','Latex','FontSize',18);xlim([1970,2020])
ylabel('$\%$','Interpreter','Latex','FontSize',18)
set(gca, 'YTickLabel', num2cell(get(gca, 'YTick')))
grid on
box on
% Figure B4 (a)
figure(3)
yyaxis left;
plot(1970:1:2019,(cpi),'k-','LineWidth',2); hold on
% yticks([log(7) log(20) log(55) log(150) log(400)]);
% yticklabels({'7','20','55','150','400'});
ylabel('$\%$','Interpreter','Latex','FontSize',18)
set(gca,'ycolor','k') ;%title('SPF w/o FE','Interpreter','Latex','FontSize',25);
yyaxis right;
plot(1970:1:2019,ngram,'--','Color',[0, 0.4470, 0.7410],'LineWidth',2); hold on
ylim([0, 0.006])
set(gca,'ycolor',[0, 0.4470, 0.7410]) ;%title('SPF w/o FE','Interpreter','Latex','FontSize',25);
% plot(1968.75:0.25:2019.75,X(:,3),':','Color',[0.6350, 0.0780, 0.1840],'LineWidth',1.5); %plot(1968.75:0.25:2019.75,X(:,2),'k-','LineWidth',2)
leg = legend('Inflation','Google Books English','Interpreter','Latex','FontSize',18)
%leg.ItemTokenSize = [18,1];
% xlabel('Year','Interpreter','Latex','FontSize',18);xlim([1970,2020])
ylabel('$\%$','Interpreter','Latex','FontSize',18)
set(gca, 'YTickLabel', num2cell(get(gca, 'YTick')))
grid on

box on
% Figure B4 (b)
figure(4)
yyaxis left;
plot(1970:1:2019,(inflations),'k-','LineWidth',2); hold on; set(gca, 'YScale', 'log')
yticks([ 7 20 55 150 400])
xticklabels({'7','20','55','150','400','Interpreter','Latex','FontSize',12})
% yticks([log(7) log(20) log(55) log(150) log(400)]);
% yticklabels({'7','20','55','150','400'});
ylabel('$\%$','Interpreter','Latex','FontSize',18)
set(gca,'ycolor','k') ;%title('SPF w/o FE','Interpreter','Latex','FontSize',25);
yyaxis right;
plot(1970:1:2019,ngrams,'--','Color',[0, 0.4470, 0.7410],'LineWidth',2); hold on
set(gca,'ycolor',[0, 0.4470, 0.7410]) ;%title('SPF w/o FE','Interpreter','Latex','FontSize',25);
% plot(1968.75:0.25:2019.75,X(:,3),':','Color',[0.6350, 0.0780, 0.1840],'LineWidth',1.5); %plot(1968.75:0.25:2019.75,X(:,2),'k-','LineWidth',2)
leg = legend('Inflation (log)','Google Books Spanish','Interpreter','Latex','FontSize',18)
%leg.ItemTokenSize = [18,1];
% xlabel('Year','Interpreter','Latex','FontSize',18);xlim([1970,2020])
ylabel('$\%$','Interpreter','Latex','FontSize',18)
set(gca, 'YTickLabel', num2cell(get(gca, 'YTick')))
grid on
box on




