// Greenbook (Table B2):
use greenbook.dta, clear
tsset date_q


rename greenbook exp_pi
keep if date_q < yq(2020,1)
gen Epi = (1+exp_pi/100)^(1/4)-1


rename gdpdef pi

gen lhs = Epi-l.Epi
gen rhs = pi-l.Epi


gen lag_Epi = l.Epi

newey Epi l.Epi rhs if date_q < yq(1990,1), lag(4)
nlcom (ratio1: _b[rhs]/_b[l.Epi]), post
newey Epi l.Epi rhs if date_q >= yq(1990,1), lag(4)
nlcom (ratio1: _b[rhs]/_b[l.Epi]), post


// Livingston (Table B2):

use livingston_cpi.dta, clear
tsset period


gen lhs = Epi-l.Epi
gen rhs = pi-l.Epi


gen lag_Epi = l.Epi

newey Epi l.Epi rhs if date < 1990, lag(4)
nlcom (ratio1: _b[rhs]/_b[l.Epi]), post
newey Epi l.Epi rhs if date >= 1990 , lag(4)
nlcom (ratio1: _b[rhs]/_b[l.Epi]), post

// SPF CPI (Table B2):
use individual_cpi.dta, clear

tsset id yq, q

keep if yq < yq(2020,1)
merge m:m yq using sd_pi.dta
tsset id yq, quarterly

gen Epi = (1+cpi3/100)^(1/4)-1
gen Epi6m = (1+cpi4/100)^(1/4)-1
gen pi = cpi

gen perc_pi = (1+cpi2/100)^(1/4)-1

//replace pi = perc_pi

gen lhs = Epi - l.pi
gen rhs = pi - l.Epi 



gen lag_Epi = l.Epi 
bysort id: gen id_freq = _N
drop if id_freq < 8

// Pooled OLS:
reg Epi l.Epi rhs if yq < yq(1990,1), r
nlcom ratio:_b[rhs]/(_b[L1.Epi]), post
reg Epi l.Epi rhs if yq >= yq(1990,1), r
nlcom ratio:_b[rhs]/(_b[L1.Epi]), post

// Blundell-Bond
xtdpdsys Epi rhs if  yq < yq(1990,1), vce(r)
estat abond
nlcom ratio:_b[rhs]/_b[L1.Epi], post
xtdpdsys Epi rhs if yq >= yq(1990,1) , vce(r)
estat abond
nlcom ratio:_b[rhs]/_b[L1.Epi], post


// Table B3: 

// Load the SPF data 
use individual_spf.dta, clear 

// Set id and time variable, set frequency to quarterly
tsset id yq, quarterly


keep if yq < yq(2020,1) // end sample at the end of 2019
// Construct expected inflation such that it is in the same units as actual inflation 
gen Epi = (1+exp_pi/100)^(1/4)-1 
// Construct right-hand side variable (capturing the forecast error that is realized in the current period)
gen rhs = pi - l.Epi 
// Define lagged expected inflation:
gen lag_Epi = l.Epi 
// Exclude forecasters with less than 8 observations:
bysort id: gen id_freq = _N
drop if id_freq < 8 // 




// The following commands yield the results for the Professional Foecasters reported in Table 1 (the last two specifications, in particular the commands "estat abond", also give the results reported in footnote 14).

// Blundell Bond before 1985:
xtdpdsys Epi rhs if yq <  yq(1985,1), vce(r)
estat abond
nlcom ratio:_b[rhs]/_b[L1.Epi], post
// Blundell Bond after 1985s:
xtdpdsys Epi rhs if yq >=  yq(1985,1), vce(r)
estat abond
nlcom ratio:_b[rhs]/_b[L1.Epi], post
// Pooled OLS before 1985s:
reg Epi l.Epi rhs if yq < yq(1985,1), r
nlcom ratio:_b[rhs]/(_b[L1.Epi]), post
// Pooled OLS after 1985:
reg Epi l.Epi rhs if yq >= yq(1985,1), r
nlcom ratio:_b[rhs]/(_b[L1.Epi]), post

// Consumers:

// Load the data 
use soc.dta, clear
tsset date_q



keep if date_q < yq(2020,1)
gen Epi = (1+michigan_exp/100)^(1/4)-1
gen Epi_median = (1+michigan_median/100)^(1/4)-1


gen pi = (1+cpi_annual/100)^(1/4)-1


gen rhs = pi-l.Epi
gen rhs_median = pi - l.Epi_median


// Before 1985 using mean expectations:
newey Epi l.Epi rhs if date_q < yq(1985,1), lag(4)
nlcom ratio:_b[rhs]/(_b[L1.Epi]), post
// After 1985 using mean expectations:
newey Epi l.Epi rhs if date_q >= yq(1985,1), lag(4)
nlcom ratio:_b[rhs]/(_b[L1.Epi]), post
// Before 1985 using median expectations:
newey Epi_median l.Epi_median rhs_median if date_q < yq(1985,1), lag(4)
nlcom ratio:_b[rhs_median]/(_b[L1.Epi_median]), post
// After 1985 using median expectations:
newey Epi_median l.Epi_median rhs_median if date_q >= yq(1985,1), lag(4)
nlcom ratio:_b[rhs_median]/(_b[L1.Epi_median]), post




// Table B4: 

// Load the SPF data 
use individual_spf.dta, clear 

// Set id and time variable, set frequency to quarterly
tsset id yq, quarterly


keep if yq < yq(2020,1) // end sample at the end of 2019
// Construct expected inflation such that it is in the same units as actual inflation 
gen Epi = (1+exp_pi/100)^(1/4)-1 
// Construct right-hand side variable (capturing the forecast error that is realized in the current period)
gen rhs = pi - l.Epi 
// Define lagged expected inflation:
gen lag_Epi = l.Epi 
// Exclude forecasters with less than 8 observations:
bysort id: gen id_freq = _N
drop if id_freq < 8 // 




// The following commands yield the results for the Professional Foecasters reported in Table 1 (the last two specifications, in particular the commands "estat abond", also give the results reported in footnote 14).

// Blundell Bond before 1995:
xtdpdsys Epi rhs if yq <  yq(1995,1), vce(r)
estat abond
nlcom ratio:_b[rhs]/_b[L1.Epi], post
// Blundell Bond after 1995s:
xtdpdsys Epi rhs if yq >=  yq(1995,1), vce(r)
estat abond
nlcom ratio:_b[rhs]/_b[L1.Epi], post
// Pooled OLS before 1995s:
reg Epi l.Epi rhs if yq < yq(1995,1), r
nlcom ratio:_b[rhs]/(_b[L1.Epi]), post
// Pooled OLS after 1995:
reg Epi l.Epi rhs if yq >= yq(1995,1), r
nlcom ratio:_b[rhs]/(_b[L1.Epi]), post

// Consumers:

// Load the data 
use soc.dta, clear
tsset date_q



keep if date_q < yq(2020,1)
gen Epi = (1+michigan_exp/100)^(1/4)-1
gen Epi_median = (1+michigan_median/100)^(1/4)-1


gen pi = (1+cpi_annual/100)^(1/4)-1


gen rhs = pi-l.Epi
gen rhs_median = pi - l.Epi_median


// Before 1995 using mean expectations:
newey Epi l.Epi rhs if date_q < yq(1995,1), lag(4)
nlcom ratio:_b[rhs]/(_b[L1.Epi]), post
// After 1995 using mean expectations:
newey Epi l.Epi rhs if date_q >= yq(1995,1), lag(4)
nlcom ratio:_b[rhs]/(_b[L1.Epi]), post
// Before 1995 using median expectations:
newey Epi_median l.Epi_median rhs_median if date_q < yq(1995,1), lag(4)
nlcom ratio:_b[rhs_median]/(_b[L1.Epi_median]), post
// After 1995 using median expectations:
newey Epi_median l.Epi_median rhs_median if date_q >= yq(1995,1), lag(4)
nlcom ratio:_b[rhs_median]/(_b[L1.Epi_median]), post





// Table B5:

// Load the SPF data 
use individual_spf.dta, clear 

// Set id and time variable, set frequency to quarterly
tsset id yq, quarterly


keep if yq < yq(2020,1) // end sample at the end of 2019
// Construct expected inflation such that it is in the same units as actual inflation 
gen Epi = (1+exp_pi/100)^(1/4)-1 
// Construct right-hand side variable (capturing the forecast error that is realized in the current period)
gen rhs = pi - l.Epi 
// Define lagged expected inflation:
gen lag_Epi = l.Epi 
// Exclude forecasters with less than 8 observations:
bysort id: gen id_freq = _N
drop if id_freq < 8 // 
// Maximum 20 lags
xtdpdsys Epi rhs if yq < yq(1990,1),  maxld(20) maxlag(20) vce(r)
estat abond
nlcom ratio:_b[rhs]/_b[L1.Epi], post

xtdpdsys Epi rhs if yq >= yq(1990,1),  maxld(20) maxlag(20) vce(r)
estat abond
nlcom ratio:_b[rhs]/_b[L1.Epi], post

// Maximum 10 lags
xtdpdsys Epi rhs if yq < yq(1990,1),  maxld(10) maxlag(10) vce(r)
estat abond
nlcom ratio:_b[rhs]/_b[L1.Epi], post

xtdpdsys Epi rhs if yq >= yq(1990,1),  maxld(10) maxlag(10) vce(r)
estat abond
nlcom ratio:_b[rhs]/_b[L1.Epi], post


// Time fixed effects:

// Load the data
use individual_spf.dta, clear 

// Set id and time variable, set frequency to quarterly
tsset id yq, quarterly


keep if yq < yq(2020,1) // end sample at the end of 2019
merge m:m yq using sd_pi.dta // merge with data on actual inflation
tsset id yq, quarterly // have to set id and time variable again after merge

// Construct expected inflation such that it is in the same units as actual inflation 
gen Epi = (1+exp_pi/100)^(1/4)-1 
// Construct right-hand side variable (capturing the forecast error that is realized in the current period)
gen rhs = pi - l.Epi 
// Define lagged expected inflation:
gen lag_Epi = l.Epi 
// Exclude forecasters with less than 8 observations:
bysort id: gen id_freq = _N
drop if id_freq < 8 // 


		
// Time fixed effects
corr Epi l.Epi if yq  < yq(1990,1)
gen lhs_pre = (Epi - r(rho)*l.Epi)/r(rho)
xtreg lhs_pre i.yq rhs if yq  < yq(1990,1), fe	

corr Epi l.Epi if yq  >= yq(1990,1)
gen lhs_post = (Epi - r(rho)*l.Epi)/r(rho)
xtreg lhs_post i.yq rhs if yq  >= yq(1990,1), fe	


reg Epi l.Epi rhs if yq < yq(1990,1)
gen rho_pre90 = _b[l.Epi]
gen lhs_pre90 = (Epi - rho_pre90*l.Epi)/rho_pre90
xtreg lhs_pre90 i.yq rhs if yq < yq(1990,1)

reg Epi l.Epi rhs if yq >= yq(1990,1)
gen rho_post90 = _b[l.Epi]
gen lhs_post90 = (Epi - rho_post90*l.Epi)/rho_post90
xtreg lhs_post90 i.yq rhs if yq >= yq(1990,1)

gen attention_1 =.
gen attention_2 =.
gen rho1 =.
gen rho_aux =.
gen ssdpi = .
gen rrho =.
gen lhs_1 =.
forvalues i=75/239{
	quietly corr Epi l.Epi if yq >= `i'-40 & yq < `i'
	gen lhs_1`i' = (Epi - r(rho)*l.Epi)/r(rho) 
	quietly xtreg lhs_1`i' i.yq rhs if yq >= `i'-40 & yq < `i', fe
	replace attention_1 = (_b[rhs]) if _n == `i'+1 
	quietly corr Epi l.Epi if yq >= `i'-40 & yq < `i'
	replace rho1 = r(rho) if _n == `i'+1 
	quietly sum pi if yq >= `i'-40 & yq < `i', d
	replace ssdpi = r(sd) if _n == `i'+1
	quietly reg Epi l.Epi rhs if yq >= `i'-40 & yq < `i'
	gen lhs_aux`i' =  (Epi - _b[l.Epi]*l.Epi)/_b[l.Epi]
	replace rho_aux = _b[l.Epi] if _n == `i'+1
	quietly xtreg lhs_aux`i' i.yq rhs if yq >= `i'-40 & yq < `i', fe
	replace attention_2 = (_b[rhs]) if _n == `i'+1 
	quietly corr pi l.pi if yq >= `i'-40 & yq < `i'
	replace rrho = r(rho) if _n == `i'+1 

	}
	
gen sdpi = ssdpi*400
reg attention_1 sdpi, r
reg attention_1 rrho, r
	
reg attention_2 sdpi, r
reg attention_2 rrho, r
	
	
// Tables B6 and B7 for the SPF


// Load the data
use individual_spf.dta, clear 

// Set id and time variable, set frequency to quarterly
tsset id yq, quarterly


keep if yq < yq(2020,1) // end sample at the end of 2019
merge m:m yq using sd_pi.dta // merge with data on actual inflation
tsset id yq, quarterly // have to set id and time variable again after merge

// Construct expected inflation such that it is in the same units as actual inflation 
gen Epi = (1+exp_pi/100)^(1/4)-1 
// Construct right-hand side variable (capturing the forecast error that is realized in the current period)
gen rhs = pi - l.Epi 
// Define lagged expected inflation:
gen lag_Epi = l.Epi 
// Exclude forecasters with less than 8 observations:
bysort id: gen id_freq = _N
drop if id_freq < 8 // 




gen gamma_ols =.
gen gammabb =.
gen ssdpi =.
gen mpi =.
gen rrho =.
gen ssdpie =.
gen rrhoe =.
forvalues i=75/239{
	quietly reg Epi l.Epi rhs if yq >= `i'-40 & yq < `i', r
	replace gamma_ols = (_b[rhs])/_b[l.Epi] if _n == `i'+1 
	quietly sum pi if yq >= `i'-40 & yq < `i', d
	replace ssdpi = r(sd) if _n == `i'+1
	replace mpi = r(mean) if _n == `i'+1
	quietly corr pi l.pi if yq >= `i'-40 & yq < `i'
	replace rrho = r(rho) if _n == `i'+1 
	quietly xtdpdsys Epi rhs if yq >= `i'-40 & yq < `i'
	replace gammabb = (_b[rhs]/_b[L1.Epi]) if _n == `i'+1 
	quietly sum Epi if yq >= `i'-40 & yq < `i', d
	replace ssdpie = r(sd) if _n == `i'+1
	quietly corr Epi l.Epi if yq >= `i'-40 & yq < `i'
	replace rrhoe = r(rho) if _n == `i'+1 

	}
	
	

gen sdpi = ssdpi*400
gen sdpie = ssdpie*400
gen avg_pi = mpi*400


// Construct Table B6 (for SPF): Attention, inflation volatility and inflation persistence
reg gammabb sdpi rrho, r // SPF BB
reg gamma_ols sdpi rrho, r // SPF OLS

// Table B7: Controlling for average inflation
reg gammabb sdpi rrho avg_pi, r // SPF BB
reg gamma_ols sdpi rrho avg_pi, r // SPF OLS

// Table B10 (for SPF):
reg gammabb sdpie, r // SPF BB
reg gammabb rrhoe, r // SPF BB
reg gamma_ols sdpie, r // SPF OLS
reg gamma_ols rrhoe, r // SPF OLS




// Tables B6 and B10 for SoC:
use soc.dta, clear
tsset date_q
keep if date_q < yq(2020,1)
gen Epi = (1+michigan_exp/100)^(1/4)-1
gen Epi_median = (1+michigan_median/100)^(1/4)-1
gen pi = (1+cpi_annual/100)^(1/4)-1
gen rhs = pi-l.Epi
gen rhs_median = pi - l.Epi_median
gen lag_Epi = l.Epi
gen gammat =.
gen avg_inf =.
gen sd_inf =.
gen rrho =.
gen rrrho =.
gen ssdpie =.
gen rrhoe =.

forvalues i=41/205{

	quietly reg Epi rhs lag_Epi if period >= `i'-40 & period < `i'
	replace gammat = (_b[rhs]/_b[lag_Epi]) if _n == `i'+1 
	replace rrrho = _b[lag_Epi] if _n == `i'+1 
	quietly sum pi if period >= `i'-40 & period < `i',d
	replace avg_inf = r(p50) if _n == `i'+1 
	replace sd_inf = r(sd) if _n == `i'+1 
	quietly corr pi l.pi if period >= `i'-40 & period < `i'
	replace rrho = r(rho) if _n == `i'+1 
	quietly sum Epi if period >= `i'-40 & period < `i', d
	replace ssdpie = r(sd) if _n == `i'+1
	quietly corr Epi l.Epi if period >= `i'-40 & period < `i'
	replace rrhoe = r(rho) if _n == `i'+1 
				}	
gen sdpi = sd_inf*400	
gen sdpie = ssdpie * 400

// Construct Table B6 (for SoC): 
reg gammat sdpi rrho, r 


// Table B10 (for SoC):
reg gammat sdpie, r 
reg gammat rrhoe, r 

//
// Quasi-panel SoC:
use quasipanel_michigan.dta, clear

tsset id yq, quarterly

keep if yq < yq(2020,1)

gen Epi = mean_exp
gen pi = cpi

gen lhs = Epi - l.Epi
gen rhs = pi - l.Epi 


gen lag_Epi = l.Epi 
// Blundell-Bond
xtdpdsys Epi rhs if yq  < yq(1990,1), vce(r)
estat abond
nlcom ratio:_b[rhs]/_b[L1.Epi], post

xtdpdsys Epi rhs if yq >= yq(1990,1), vce(r)
estat abond
nlcom ratio:_b[rhs]/_b[L1.Epi], post

xtdpdsys Epi rhs if yq  < yq(1995,1), vce(r)
estat abond
nlcom ratio:_b[rhs]/_b[L1.Epi], post

xtdpdsys Epi rhs if yq >= yq(1995,1), vce(r)
estat abond
nlcom ratio:_b[rhs]/_b[L1.Epi], post




gen kgainbb =.
gen ssdpi =.
gen rrho =.
forvalues i=119/239{
	quietly sum pi if yq >= `i'-40 & yq < `i' , d
	replace ssdpi = r(sd) if _n == `i'+1
	quietly corr pi l.pi if yq >= `i'-40 & yq < `i' 
	replace rrho = r(rho) if _n == `i'+1 
	quietly xtdpdsys Epi rhs if yq >= `i'-40 & yq < `i'
	replace kgainbb = (_b[rhs]/_b[L1.Epi]) if _n == `i'+1 

	}
	
// Table B9:
reg kgainbb ssdpi rrho,r
reg kgainbb rrho, r
reg kgainbb ssdpi, r

//
// Table B11:

// Load the data
use individual_spf.dta, clear 

// Set id and time variable, set frequency to quarterly
tsset id yq, quarterly


keep if yq < yq(2020,1) // end sample at the end of 2019

// Construct expected inflation such that it is in the same units as actual inflation 
gen Epi = (1+exp_pi/100)^(1/4)-1 
// Construct right-hand side variable (capturing the forecast error that is realized in the current period)
gen rhs = pi - l.Epi 
// Define lagged expected inflation:
gen lag_Epi = l.Epi 
// Exclude forecasters with less than 8 observations:
bysort id: gen id_freq = _N
drop if id_freq < 8 // 




gen gamma_ols =.
gen gammabb =.
gen ssdpi =.
gen mpi =.
gen rrho =.
gen ssdpie =.
gen rrhoe =.
forvalues i=55/239{
	quietly reg Epi l.Epi rhs if yq >= `i'-20 & yq < `i', r
	replace gamma_ols = (_b[rhs])/_b[l.Epi] if _n == `i'+1 
	quietly sum pi if yq >= `i'-20 & yq < `i', d
	replace ssdpi = r(sd) if _n == `i'+1
	replace mpi = r(mean) if _n == `i'+1
	quietly corr pi l.pi if yq >= `i'-20 & yq < `i'
	replace rrho = r(rho) if _n == `i'+1 
	quietly xtdpdsys Epi rhs if yq >= `i'-20 & yq < `i'
	replace gammabb = (_b[rhs]/_b[L1.Epi]) if _n == `i'+1 
	quietly sum Epi if yq >= `i'-20 & yq < `i', d
	replace ssdpie = r(sd) if _n == `i'+1
	quietly corr Epi l.Epi if yq >= `i'-20 & yq < `i'
	replace rrhoe = r(rho) if _n == `i'+1 

	}
	
	

gen sdpi = ssdpi*400
gen sdpie = ssdpie*400
gen avg_pi = mpi*400


// Construct Table B11 (for SPF): Attention, inflation volatility and inflation persistence
reg gammabb sdpi, r // SPF BB
reg gammabb rrho, r // SPF BB

reg gamma_ols sdpi, r // SPF OLS
reg gamma_ols rrho, r // SPF OLS




//
// Table B12:
// Load the data
use individual_spf.dta, clear 

// Set id and time variable, set frequency to quarterly
tsset id yq, quarterly


keep if yq < yq(2020,1) // end sample at the end of 2019

// Construct expected inflation such that it is in the same units as actual inflation 
gen Epi = (1+exp_pi/100)^(1/4)-1 
// Construct right-hand side variable (capturing the forecast error that is realized in the current period)
gen rhs = pi - l.Epi 
// Define lagged expected inflation:
gen lag_Epi = l.Epi 
// Exclude forecasters with less than 8 observations:
bysort id: gen id_freq = _N
drop if id_freq < 8 // 




gen gamma_ols =.
gen gammabb =.
gen ssdpi =.
gen mpi =.
gen rrho =.
gen ssdpie =.
gen rrhoe =.
forvalues i=95/239{
	quietly reg Epi l.Epi rhs if yq >= `i'-60 & yq < `i', r
	replace gamma_ols = (_b[rhs])/_b[l.Epi] if _n == `i'+1 
	quietly sum pi if yq >= `i'-60 & yq < `i', d
	replace ssdpi = r(sd) if _n == `i'+1
	replace mpi = r(mean) if _n == `i'+1
	quietly corr pi l.pi if yq >= `i'-60 & yq < `i'
	replace rrho = r(rho) if _n == `i'+1 
	quietly xtdpdsys Epi rhs if yq >= `i'-60 & yq < `i'
	replace gammabb = (_b[rhs]/_b[L1.Epi]) if _n == `i'+1 
	quietly sum Epi if yq >= `i'-60 & yq < `i', d
	replace ssdpie = r(sd) if _n == `i'+1
	quietly corr Epi l.Epi if yq >= `i'-60 & yq < `i'
	replace rrhoe = r(rho) if _n == `i'+1 

	}
	
	

gen sdpi = ssdpi*400
gen sdpie = ssdpie*400
gen avg_pi = mpi*400


// Construct Table B12 (for SPF): Attention, inflation volatility and inflation persistence
reg gammabb sdpi rrho, r // SPF BB

reg gamma_ols sdpi rrho, r // SPF OLS



//
// Table B11 for SoC:


use soc.dta, clear
tsset date_q
keep if date_q < yq(2020,1)
gen Epi = (1+michigan_exp/100)^(1/4)-1
gen Epi_median = (1+michigan_median/100)^(1/4)-1
gen pi = (1+cpi_annual/100)^(1/4)-1
gen rhs = pi-l.Epi
gen rhs_median = pi - l.Epi_median
gen lag_Epi = l.Epi
gen gammat =.
gen avg_inf =.
gen sd_inf =.
gen rrho =.
gen rrrho =.
gen ssdpie =.
gen rrhoe =.

forvalues i=21/205{

	quietly reg Epi rhs lag_Epi if period >= `i'-20 & period < `i'
	replace gammat = (_b[rhs]/_b[lag_Epi]) if _n == `i'+1 
	replace rrrho = _b[lag_Epi] if _n == `i'+1 
	quietly sum pi if period >= `i'-20 & period < `i',d
	replace avg_inf = r(p50) if _n == `i'+1 
	replace sd_inf = r(sd) if _n == `i'+1 
	quietly corr pi l.pi if period >= `i'-20 & period < `i'
	replace rrho = r(rho) if _n == `i'+1 
	quietly sum Epi if period >= `i'-20 & period < `i', d
	replace ssdpie = r(sd) if _n == `i'+1
	quietly corr Epi l.Epi if period >= `i'-20 & period < `i'
	replace rrhoe = r(rho) if _n == `i'+1 
				}	
gen sdpi = sd_inf*400	
gen sdpie = ssdpie * 400

// Construct Table B11 (for SoC): 
reg gammat sdpi rrho, r 


//
// Table B12 for SoC:


use soc.dta, clear
tsset date_q
keep if date_q < yq(2020,1)
gen Epi = (1+michigan_exp/100)^(1/4)-1
gen Epi_median = (1+michigan_median/100)^(1/4)-1
gen pi = (1+cpi_annual/100)^(1/4)-1
gen rhs = pi-l.Epi
gen rhs_median = pi - l.Epi_median
gen lag_Epi = l.Epi
gen gammat =.
gen avg_inf =.
gen sd_inf =.
gen rrho =.
gen rrrho =.
gen ssdpie =.
gen rrhoe =.

forvalues i=61/205{

	quietly reg Epi rhs lag_Epi if period >= `i'-60 & period < `i'
	replace gammat = (_b[rhs]/_b[lag_Epi]) if _n == `i'+1 
	replace rrrho = _b[lag_Epi] if _n == `i'+1 
	quietly sum pi if period >= `i'-60 & period < `i',d
	replace avg_inf = r(p50) if _n == `i'+1 
	replace sd_inf = r(sd) if _n == `i'+1 
	quietly corr pi l.pi if period >= `i'-60 & period < `i'
	replace rrho = r(rho) if _n == `i'+1 
	quietly sum Epi if period >= `i'-60 & period < `i', d
	replace ssdpie = r(sd) if _n == `i'+1
	quietly corr Epi l.Epi if period >= `i'-60 & period < `i'
	replace rrhoe = r(rho) if _n == `i'+1 
				}	
gen sdpi = sd_inf*400	
gen sdpie = ssdpie * 400

// Construct Table B6 (for SoC): 
reg gammat sdpi rrho, r 



// Results for SPF aggregates:

use spf_agg.dta, clear
tsset date_q


rename dpgdp3 exp_pi
rename cpi2 exp_pi_current
keep if date_q < yq(2020,1)
gen Epi = (1+exp_pi/100)^(1/4)-1
gen Epi_current = (1+exp_pi_current/100)^(1/4)-1




rename gdpdef pi
gen lag_Epi = l.Epi

gen rhs = pi-l.Epi

reg Epi l.Epi rhs if date_q < yq(1990,1), r
nlcom (att1: _b[rhs]/_b[l.Epi])
reg Epi l.Epi rhs if date_q >= yq(1990,1), r
nlcom (att1: _b[rhs]/_b[l.Epi])


gen gammat =.
gen sd_inf =.
gen rrho =.

forvalues i=75/205{

	quietly reg Epi rhs lag_Epi if date_q >= `i'-40 & date_q < `i'
	replace gammat = (_b[rhs]/_b[lag_Epi]) if _n == `i'+1 
	quietly sum pi if date_q >= `i'-40 & date_q < `i',d
	replace sd_inf = r(sd) if _n == `i'+1 
	quietly corr pi l.pi if date_q >= `i'-40 & date_q < `i'
	replace rrho = r(rho) if _n == `i'+1
				}	
gen sdpi = sd_inf*400	
reg gammat sdpi, r
reg gammat rrho, r

// The resulting gammat and sdpi are saved in fig_b2.xlsx and then used in FigB2.m to reproduce Figure B2.


// Table B13: AR(2) beliefs

use soc.dta, clear
tsset date_q
keep if date_q < yq(2020,1)
gen Epi = (1+michigan_exp/100)^(1/4)-1
gen Epi_median = (1+michigan_median/100)^(1/4)-1
gen pi = (1+cpi_annual/100)^(1/4)-1
gen rhs = pi-l.Epi
gen rhs_median = pi - l.Epi_median
newey Epi l.Epi l2.Epi rhs l.rhs if  date_q < yq(1990,1), lag(4)
nlcom (att1: _b[rhs]/_b[l.Epi])
nlcom (att1: _b[rhs] + _b[l.rhs])
newey Epi l.Epi l2.Epi rhs l.rhs if  date_q >= yq(1990,1), lag(4)
nlcom (att2: _b[rhs] + _b[l.rhs])

newey Epi_median l.Epi_median l2.Epi_median rhs_median l.rhs_median if  date_q < yq(1990,1), lag(4)
nlcom (att1: _b[rhs_median]/_b[l.Epi_median])
nlcom (att1: _b[rhs_median] + _b[l.rhs_median])
newey Epi_median l.Epi_median l2.Epi_median rhs_median l.rhs_median if  date_q >= yq(1990,1), lag(4)
nlcom (att1: _b[rhs_median]/_b[l.Epi_median])
nlcom (att1: _b[rhs_median] + _b[l.rhs_median])
// Households answering "I don't know"
gen lag_Epi = l.Epi
gen lag_Epi_median = l.Epi_median
gen kgain =.
gen kgain_median =.
gen avg_inf =.
gen sd_inf =.
gen rrho =.
gen rrrho =.
gen dkpi =.
forvalues i=75/206{

	quietly reg Epi rhs lag_Epi if period >= `i'-40 & period < `i'
	replace kgain = (_b[rhs]/_b[lag_Epi]) if _n == `i'+1 
	quietly reg Epi_median rhs_median lag_Epi_median if period >= `i'-40 & period < `i'
	replace kgain_median = (_b[rhs_median]/_b[lag_Epi_median]) if _n == `i'+1 
	replace rrrho = _b[lag_Epi] if _n == `i'+1 
	quietly sum pi if period >= `i'-40 & period < `i',d
	replace avg_inf = r(p50) if _n == `i'+1 
	replace sd_inf = r(sd) if _n == `i'+1 
	quietly corr Epi l.Epi if period >= `i'-40 & period < `i'
	replace rrho = r(rho) if _n == `i'+1 
	quietly sum dk_howmuch if period >= `i'-40 & period < `i'
	replace dkpi = r(mean) if _n == `i'+1
				}	
				
				

corr dkpi kgain
newey dkpi kgain, lag(4)
newey dkpi kgain sd_inf rrho avg_inf, lag(4)


corr dkpi kgain_median
newey dkpi kgain_median, lag(4)
newey dkpi kgain_median sd_inf rrho avg_inf, lag(4)


// Accuracy of Nowcasts:

use individual_spf.dta, clear

tsset id yq, q

keep if yq < yq(2020,1)




gen perceived_pi = 100*((pgdp2/pgdp1)^4-1)


gen perc_pi = (1+perceived_pi/100)^(1/4)-1


gen current_fe = pi - perc_pi
sum current_fe if year < 1990
sum current_fe if year >= 1990
gen abs_cfe = abs(current_fe)/abs(pi)
gen sq_cfe = (current_fe)^2/abs(pi)

sum abs_cfe if year < 1990
sum abs_cfe if year >= 1990

gen ssdpi_c =.
gen mpi_c =.
gen rrho_c =.
gen sqcfe =.
gen abscfe =.
forvalues i=75/239{

	quietly sum perc_pi if yq >= `i'-40 & yq < `i', d
	replace ssdpi_c = r(sd) if _n == `i'+1
	quietly corr perc_pi l.perc_pi if yq >= `i'-40 & yq < `i'
	replace rrho_c = r(rho) if _n == `i'+1 
	quietly sum sq_cfe if yq >= `i'-40 & yq < `i', d
	replace sqcfe = r(mean) if _n == `i'+1
	quietly sum abs_cfe if yq >= `i'-40 & yq < `i', d
	replace abscfe = r(mean) if _n == `i'+1

	//	quietly xtdpdsys Epi rhs if yq >= `i'-40 & yq < `i'
//	replace kgainbb = (_b[rhs]/_b[L1.Epi]) if _n == `i'+1 

	}

	
corr sqcfe rrho_c ssdpi_c 
corr abscfe rrho_c ssdpi_c 
