cd "C:\Users\Q32334\Desktop\JEG\Research\ST and Runs\JMCB\Accepted"
log using "paper_submission", replace
********************************************************************************
/* Results of the paper 
					"Stress Tests, Information Disclosure, and Credit Line Runs" 
							 by José E. Gutiérrez and Luis Fernández Lafuerza */
********************************************************************************
qui use CL_2011_6, clear
	** NOTE: Every other database CL_2011_`month' has the same structre
	** Observations also include single-bank clients.
describe

********************************************************************************
*** Table 1: Effect of the 2011 Stress Test on Credit Line Usage
********************************************************************************
local Controls_b  = "log_Assets_b Liq_b ROA_b COMMERCIAL Mora_b k_benchmark" 
local Controls_fb = "SHARE PAST_DUE COLLATERALIZED SHORT_MATURITY USAGE"

qui use CL_2011_6, clear
qui keep if DUP == 1 // clients with CLs with more than one bank. 

qui gen UNDRAWN = GRANTED_t - USED_t

qui eststo: reghdfe yy FAILED_plus `Controls_b' `Controls_fb' if DUP == 1, absorb(cod_titular) vce(cluster COD_GRUPO cod_titular)
qui estadd local fe "Y", replace
qui estadd local controls "Y", replace

qui sum GRANTED_t, detail
qui winsor GRANTED_t, gen(TEMP) p(0.025)
qui drop GRANTED_t
qui rename TEMP GRANTED_t
qui sum GRANTED_t, detail

qui eststo: reghdfe yy FAILED_plus `Controls_b' `Controls_fb' if DUP == 1 [aw = GRANTED_t], absorb(cod_titular) vce(cluster COD_GRUPO cod_titular)
qui estadd local fe "Y", replace
qui estadd local controls "Y", replace

qui eststo: reghdfe yy FAILED_plus `Controls_b' `Controls_fb' if DUP == 1, absorb() vce(cluster COD_GRUPO cod_titular)
qui estadd local fe "N", replace
qui estadd local controls "Y", replace

qui eststo: reghdfe yy1 FAILED_plus         `Controls_b' `Controls_fb' if DUP == 1 & USAGE < 0.99, absorb(cod_titular) vce(cluster COD_GRUPO cod_titular)
qui estadd local fe "Y", replace
qui estadd local controls "Y", replace
keep if e(sample)

qui sum UNDRAWN, detail
qui winsor UNDRAWN, gen(TEMP) p(0.025)
qui drop UNDRAWN
qui rename TEMP UNDRAWN
qui sum UNDRAWN, detail

qui eststo: reghdfe yy1 FAILED_plus `Controls_b' `Controls_fb' if DUP == 1 & USAGE < 0.99 [aw = UNDRAWN] , absorb(cod_titular) vce(cluster COD_GRUPO cod_titular)
qui estadd local fe "Y", replace
qui estadd local controls "Y", replace

qui eststo: reghdfe yy1 FAILED_plus `Controls_b' `Controls_fb' if DUP == 1 & USAGE < 0.99 , absorb() vce(cluster COD_GRUPO cod_titular)
qui estadd local fe "N", replace
qui estadd local controls "Y", replace

#delimit ;
	esttab,
	title(Table 1)
	keep(FAILED_plus)
	collabels(none) 
	coeflabels(FAILED_plus "ST-Underperforming")
	label  stats(controls fe N r2, fmt(%20s %20s %9.0fc %9.4f) labels("Controls" "Firm FE" "Observations" "R-squared"))
	b(%9.3f)  se(%9.3f) 
	noabbrev nomtitle parentheses replace 
	star(* 0.10 ** 0.05 *** 0.01);
#delimit cr
eststo clear

********************************************************************************
*** Table 2: Effect of the 2011 Stress Test on the Demand for Drawdowns, Firm-Level Results
********************************************************************************
global Controls_b  = "log_Assets_b Liq_b ROA_b COMMERCIAL Mora_b k_benchmark" 
global Controls_fb = "SHARE PAST_DUE COLLATERALIZED SHORT_MATURITY USAGE"
global Controls_f  = "log_Assets_f Liq1_f Cap_f RISK_CIR ROA_f"  

qui use CL_2011_6, clear
qui keep if DUP == 1 // clients with CLs with more than one bank. 
qui reghdfe yy FAILED_plus $Controls_b $Controls_fb, absorb(cod_titular) vce(cluster COD_GRUPO cod_titular) 
qui keep if e(sample)

/* We aggregate database at the firm level using GRANTED_t as weight */
qui replace PAST_DUE       = PAST_DUE*GRANTED_t
qui replace COLLATERALIZED = COLLATERALIZED*GRANTED_t
qui replace SHORT_MATURITY = SHORT_MATURITY*GRANTED_t
qui replace log_Assets_b       = log_Assets_b*GRANTED_t
qui replace Liq_b = Liq_b*GRANTED_t
qui replace ROA_b = ROA_b*GRANTED_t
qui replace COMMERCIAL = COMMERCIAL*GRANTED_t
qui replace Mora_b = Mora_b*GRANTED_t
qui replace k_benchmark = k_benchmark*GRANTED_t
qui gsort cod_titular COD_GRUPO -GRANTED_t

qui collapse (sum) USED_t USED_t1 GRANTED_t PAST_DUE COLLATERALIZED SHORT_MATURITY log_Assets_b Liq_b ROA_b COMMERCIAL Mora_b k_benchmark (max) Treated = FAILED_plus (first) RISK_CIR INDUSTRY_GROUPS cod_provincia SIZE DUP COD_GRUPO log_Assets_f Liq1_f Cap_f ROA_f (mean) SHARE, by(cod_titular)  

qui replace PAST_DUE       = PAST_DUE/GRANTED_t
qui replace COLLATERALIZED = COLLATERALIZED/GRANTED_t
qui replace SHORT_MATURITY = SHORT_MATURITY/GRANTED_t
qui replace log_Assets_b       = log_Assets_b/GRANTED_t
qui replace Liq_b = Liq_b/GRANTED_t
qui replace ROA_b = ROA_b/GRANTED_t
qui replace COMMERCIAL = COMMERCIAL/GRANTED_t
qui replace Mora_b = Mora_b/GRANTED_t
qui replace k_benchmark = k_benchmark/GRANTED_t

qui gen yy = (USED_t1 -USED_t )/GRANTED_t 
qui gen yy1 = (USED_t1 -USED_t )/(GRANTED_t -USED_t)
qui gen USAGE = USED_t/GRANTED_t

qui eststo: reghdfe yy Treated $Controls_fb $Controls_b, a(INDUSTRY_GROUPS#cod_provincia#SIZE) cluster(COD_GRUPO)
qui estadd local fe "Y", replace
qui estadd local fcontrols "N", replace
qui estadd local controls "Y", replace
qui eststo: reghdfe yy Treated $Controls_fb $Controls_b if log_Assets_f!=., a(INDUSTRY_GROUPS#cod_provincia#SIZE) cluster(COD_GRUPO)
qui estadd local fe "Y", replace
qui estadd local fcontrols "N", replace
qui estadd local controls "Y", replace
qui eststo: reghdfe yy Treated  $Controls_fb $Controls_b $Controls_f if log_Assets_f~=., a(INDUSTRY_GROUPS#cod_provincia#SIZE) cluster(COD_GRUPO)
qui estadd local fe "Y", replace
qui estadd local fcontrols "Y", replace
qui estadd local controls "Y", replace

qui use CL_2011_6, clear
qui keep if DUP == 1
qui reghdfe yy1 FAILED_plus $Controls_b $Controls_fb if USAGE<0.99, absorb(cod_titular) vce(cluster COD_GRUPO cod_titular) 
qui keep if e(sample)

qui replace PAST_DUE       = PAST_DUE*GRANTED_t
qui replace COLLATERALIZED = COLLATERALIZED*GRANTED_t
qui replace SHORT_MATURITY = SHORT_MATURITY*GRANTED_t
qui replace log_Assets_b       = log_Assets_b*GRANTED_t
qui qui replace Liq_b = Liq_b*GRANTED_t
qui replace ROA_b = ROA_b*GRANTED_t
qui replace COMMERCIAL = COMMERCIAL*GRANTED_t
qui replace Mora_b = Mora_b*GRANTED_t
qui replace k_benchmark = k_benchmark*GRANTED_t
qui gsort cod_titular COD_GRUPO -GRANTED_t

qui collapse (sum) USED_t USED_t1 GRANTED_t PAST_DUE COLLATERALIZED SHORT_MATURITY log_Assets_b Liq_b ROA_b COMMERCIAL Mora_b k_benchmark (max) Treated = FAILED_plus (first) RISK_CIR INDUSTRY_GROUPS cod_provincia SIZE DUP COD_GRUPO log_Assets_f Liq1_f Cap_f ROA_f (mean) SHARE, by(cod_titular)  

qui replace PAST_DUE       = PAST_DUE/GRANTED_t
qui replace COLLATERALIZED = COLLATERALIZED/GRANTED_t
qui replace SHORT_MATURITY = SHORT_MATURITY/GRANTED_t
qui replace log_Assets_b       = log_Assets_b/GRANTED_t
qui replace Liq_b = Liq_b/GRANTED_t
qui replace ROA_b = ROA_b/GRANTED_t
qui replace COMMERCIAL = COMMERCIAL/GRANTED_t
qui replace Mora_b = Mora_b/GRANTED_t
qui replace k_benchmark = k_benchmark/GRANTED_t

qui gen yy = (USED_t1 -USED_t )/GRANTED_t 
qui gen yy1 = (USED_t1 -USED_t )/(GRANTED_t -USED_t)
qui gen USAGE = USED_t/GRANTED_t

qui eststo: reghdfe yy1 Treated $Controls_fb $Controls_b, a(INDUSTRY_GROUPS#cod_provincia#SIZE) cluster(COD_GRUPO)
qui estadd local fe "Y", replace
qui estadd local fcontrols "N", replace
qui estadd local controls "Y", replace
qui eststo: reghdfe yy1 Treated $Controls_fb $Controls_b if log_Assets_f!=., a(INDUSTRY_GROUPS#cod_provincia#SIZE) cluster(COD_GRUPO)
qui estadd local fe "Y", replace
qui estadd local fcontrols "N", replace
qui estadd local controls "Y", replace
qui eststo: reghdfe yy1 Treated  $Controls_fb $Controls_b $Controls_f if log_Assets_f~=., a(INDUSTRY_GROUPS#cod_provincia#SIZE) cluster(COD_GRUPO)
qui estadd local fe "Y", replace
qui estadd local fcontrols "Y", replace
qui estadd local controls "Y", replace

#delimit ;
	esttab,
	title(Table 2)
	keep(Treated)
	collabels(none) 
	coeflabels(Treated "Treated")
	label  stats(fe fcontrols controls N r2, fmt(%20s %20s %20s %9.0fc %9.4f) labels("Firm-cluster FE" "Firm controls" "Other controls" "Observations" "R-squared"))
	b(%9.3f)  se(%9.3f) 
	noabbrev nomtitle parentheses replace 
	star(* 0.10 ** 0.05 *** 0.01);
#delimit cr
eststo clear	

********************************************************************************
*** Figure 1: Credit line usage rate change between underperforming and performing banks
********************************************************************************
local Controls_b  = "log_Assets_b Liq_b ROA_b COMMERCIAL Mora_b k_benchmark" 
local Controls_fb = "SHARE PAST_DUE COLLATERALIZED SHORT_MATURITY USAGE"
matrix A = J(7,3,0)
local i = 1
foreach month in 2010_6 2011_3 2011_4 2011_5 2011_6 2011_7 2011_8 {
	use CL_`month', clear
	qui reghdfe yy 1.FAILED_plus `Controls_b' `Controls_fb' if DUP == 1, absorb(cod_titular) vce(cluster COD_GRUPO cod_titular)
	matrix A[`i',1] = r(table)[1,1] * 100
	matrix A[`i',2] = r(table)[5,1] * 100
	matrix A[`i',3] = r(table)[6,1] * 100
	local i = `i' + 1
}
/* The matrix contains the point estimates in column 1 and CI (columns 2 and 3) employed to elaborate the Figure 1. */
 matlist A

********************************************************************************
*** Table 3: Reversal in Precautionary Drawdowns
********************************************************************************
local Controls_fb = "SHARE PAST_DUE COLLATERALIZED SHORT_MATURITY USAGE"
local Controls_b  = "log_Assets_b Liq_b ROA_b COMMERCIAL Mora_b k_benchmark" 

//Column (1)
qui use CL_2011_6, clear
	qui keep if DUP == 1 
	qui eststo: reghdfe yy 1.FAILED_plus `Controls_b' `Controls_fb', absorb(cod_titular) vce(cluster COD_GRUPO cod_titular)
	qui estadd local fe "Y", replace
	qui estadd local controls "Y", replace

* We create a list of firms that ran on July following the disclosure date.	
	qui egen BUENO = mean(yy) if FAILED_plus == 0, by(FAILED_plus cod_titular) // Average increase in usage with performing banks
	qui egen MALO  = mean(yy) if FAILED_plus == 1, by(FAILED_plus cod_titular) // Average increase in usage with underperforming banks 
	qui egen BUENO_ = max(BUENO), by(cod_titular)
	qui egen MALO_  = max(MALO) , by(cod_titular)
	qui keep if temp_f == 1 
	qui keep cod_titular BUENO_ MALO_
	qui gen DIF = MALO_ - BUENO_ // diff. in average increase between underperforming and performing banks 
	qui keep if DIF ~= . // Firms with CLs granted by underperforming and performing banks 
	qui gen RUN = 0
	qui replace RUN = 1 if MALO_ > 0 & DIF > 0 // "Running" firm if average increase with underperforming banks was positive and greater than the average increase with performing banks
	qui keep if RUN == 1 
	qui keep cod_titular RUN
qui save LISTA_RUN, replace 

//Column (2)
qui use CL_2011_7, clear
	qui keep if DUP == 1
	qui merge m:1 cod_titular using LISTA_RUN
	qui drop if _merge == 2 
	qui replace RUN = 0 if _merge == 1
	qui drop _merge

	qui eststo: reghdfe yy 1.FAILED_plus 1.FAILED_plus#1.RUN  `Controls_b' `Controls_fb', absorb(cod_titular) vce(cluster COD_GRUPO cod_titular)
	qui estadd local fe "Y", replace
	qui estadd local controls "Y", replace
	
*We update our list of firms that ran on August.
qui use CL_2011_7, clear 
	qui keep if DUP == 1
	qui egen BUENO = mean(yy) if FAILED_plus == 0, by(FAILED_plus cod_titular)
	qui egen MALO  = mean(yy) if FAILED_plus == 1, by(FAILED_plus cod_titular)
	qui egen BUENO_ = max(BUENO), by(cod_titular)
	qui egen MALO_  = max(MALO) , by(cod_titular)
	qui keep if temp_f == 1 
	qui keep cod_titular BUENO_ MALO_
	qui gen DIF = MALO_ - BUENO_
	qui keep if DIF ~= . 
	qui gen RUN = 0   
	qui replace RUN = 2 if MALO_ > 0 & DIF > 0
	qui keep if RUN == 2
	qui keep cod_titular RUN
	qui append using LISTA_RUN 
	qui duplicates drop cod_titular, force 
qui save LISTA_RUN, replace

qui use CL_2011_8, clear
	qui keep if DUP == 1
	qui merge m:1 cod_titular using LISTA_RUN
	qui drop if _merge == 2
	qui replace RUN = 0 if _merge == 1
	qui drop _merge
	qui gen RUN1=RUN
	qui replace RUN1=1 if RUN==2
	qui drop RUN
	qui rename RUN1 RUN

	qui eststo: reghdfe yy 1.FAILED_plus 1.FAILED_plus#1.RUN log_Assets_b Liq_b ROA_b COMMERCIAL Mora_b k_benchmark SHARE PAST_DUE COLLATERALIZED SHORT_MATURITY USAGE, absorb(cod_titular) vce(cluster COD_GRUPO cod_titular)
	qui estadd local fe "Y", replace
	qui estadd local controls "Y", replace

#delimit ;
	esttab, title(Table 3) drop(`Controls_b' `Controls_fb' _cons) collabels(none)	coeflabels(1.FAILED_plus "ST-Underperforming" 1.FAILED_plus#1.RUN "ST-Underperforming x RUN")
	label  stats(controls fe N r2, fmt(%20s %20s %9.0fc %9.3f) labels("Controls" "Firm FE" "Observations" "R-squared"))
	b(%9.3f)  se(%9.3f) 
	nomtitle parentheses 
	star(* 0.10 ** 0.05 *** 0.01);
#delimit cr
eststo clear	

********************************************************************************
* Table 4: Banks' Credit Line Risk Management
********************************************************************************
use CL_Limit_2, clear
describe
* The other datasets share the same structure, but differ in the quarter of analysis

foreach k in 0.90 0.80 {
	forval t = 1(1)3 {
		qui use CL_Limit_`t', clear 
		qui gen DECREASE = 0
		qui replace DECREASE = 1 if NEW_GRANTED_t1 < `k'*GRANTED_t
		local Controls_fb = "SHARE PAST_DUE COLLATERALIZED USAGE EXPIRING_"
		local Controls_b  = "log_Assets_b Liq_b ROA_b Mora_b k_benchmark COMMERCIAL" 
		qui eststo: reghdfe DECREASE  1.FAILED_plus `Controls_b' `Controls_fb', absorb(cod_titular) vce(cluster COD_GRUPO cod_titular)
		qui estadd local fe "Y", replace
		qui estadd local controls "Y", replace
	}	
}
forval t =  1(1)3 {
		qui use CL_Limit_`t', clear 
		qui gen DECREASE = log(NEW_GRANTED_t1)-log(GRANTED_t)
		local Controls_fb = "SHARE PAST_DUE COLLATERALIZED USAGE EXPIRING_"
		local Controls_b  = "log_Assets_b Liq_b ROA_b Mora_b k_benchmark COMMERCIAL" 
		qui eststo: reghdfe DECREASE  1.FAILED_plus `Controls_b' `Controls_fb', absorb(cod_titular) vce(cluster COD_GRUPO cod_titular)
		qui estadd local fe "Y", replace
		qui estadd local controls "Y", replace
	}
	
#delimit ;
	esttab , title(Table 4) 
	keep(1.FAILED_plus)
	collabels(none) 
	coeflabels(1.FAILED_plus "ST-Underperforming")
	label  stats(controls fe N r2, fmt(%20s %20s %9.0fc %9.4f) labels("Controls" "Firm FE" "Observations" "R-squared"))
	b(%9.3f)  se(%9.3f) 
	noabbrev nomtitle parentheses 
	star(* 0.10 ** 0.05 *** 0.01);
#delimit cr
eststo clear	
********************************************************************************
* Table 5: Term Lending Supply
********************************************************************************
* Similar structure as before.
* CHANGE is the quarterly difference of the logarithm of term lending granted by bank b to firm f.
forval q = 1(1)3 {
	qui use Term_Lending_`q', clear
	qui local Controls_fb = "SHARE PAST_DUE COLLATERALIZED SHORT_MATURITY"
	qui local Controls_b    = "log_Assets_b Liq_b ROA_b COMMERCIAL Mora_b k_benchmark" 	
	qui eststo: reghdfe CHANGE  1.FAILED_plus `Controls_b' `Controls_fb', absorb(cod_titular) vce(cluster COD_GRUPO cod_titular)
	qui estadd local fe "Y", replace
	qui estadd local controls "Y", replace	
}

#delimit ;
	esttab,
	title(Table 5)
	keep(1.FAILED_plus)
	collabels(none) 
	coeflabels(1.FAILED_plus "ST-Underperforming")
	label  stats(controls fe N r2, fmt(%20s %20s %9.0fc %9.4f) labels("Controls" "Firm FE" "Observations" "R-squared"))
	b(%9.3f)  se(%9.3f) 
	noabbrev nomtitle parentheses replace 
	star(* 0.10 ** 0.05 *** 0.01);
#delimit cr
eststo clear
********************************************************************************
* Table 6: Stress-Tested Banks' Lending to Firms without Credit Lines
********************************************************************************
qui use NON_CLS_3, clear
describe
* This dataset is used to analyzed how bank lending to non-CL users evolved around our period of analysis
* The other datasets share the same structure, but differ in the quarter of analysis
local Controls_fb = "SHARE PAST_DUE COLLATERALIZED STERM"
local Controls_b  = "log_Assets_b Liq_b ROA_b COMMERCIAL Mora_b UN_TO_ASSETS k_benchmark"  
foreach k in 0.20 0.40 0.60 {
	forval t = 0(3)6 {
		qui use NON_CLS_`t', clear 
		qui gen DROP = 0
		qui replace DROP = 1 if LENDINGt1 < (1-`k')*dispuesto
		* DROP equals one if lending to firm f by bank b decreased an x% in the quarter. (x = 20, 40, 60)		
		qui eststo: reghdfe DROP  1.FAILED_plus 1.FAILED_plus#c.UN_TO_ASSETS `Controls_b' `Controls_fb', absorb(cod_titular) vce(cluster COD_GRUPO cod_titular)
		qui estadd local fe "Y", replace
		qui estadd local controls "Y", replace
	}	
}

#delimit ;
	esttab , 
	title(Table 6)
	keep(1.FAILED_plus 1.FAILED_plus#c.UN_TO_ASSETS)
	collabels(none) 
	coeflabels(1.FAILED_plus "ST-Underperforming" 1.FAILED_plus#c.UN_TO_ASSETS " x Undrawn CLs over TA")
	label  stats(controls fe N r2, fmt(%20s %20s %9.0fc %9.4f) labels("Controls" "Firm FE" "Observations" "R-squared"))
	b(%9.3f)  se(%9.3f) 
	noabbrev nomtitle parentheses 
	star(* 0.10 ** 0.05 *** 0.01);
#delimit cr
eststo clear	
********************************************************************************
* Table 7: Heterogeneous Effects on Bank Characteristics
********************************************************************************
qui use CL_2011_6, clear
	qui keep if DUP == 1
	local Controls_fb = "SHARE PAST_DUE COLLATERALIZED SHORT_MATURITY USAGE"
	local Controls_b  = "log_Assets_b Liq_b ROA_b COMMERCIAL Mora_b k_benchmark"

local interaction_c = "log_Assets_b Liq_b ROA_b Mora_b k_benchmark COMMERCIAL"
foreach var_b in `interaction_c' {
	local inter = "1.FAILED_plus 1.FAILED_plus#c.`var_b'"
	qui eststo: reghdfe yy `inter' `Controls_b' `Controls_fb', absorb(cod_titular) vce(cluster COD_GRUPO cod_titular)
		qui estadd local fe "Y", replace
		qui estadd local controls "Y", replace
	}	
	
local interactions = "1.FAILED_plus#c.log_Assets_b 1.FAILED_plus#c.Liq_b 1.FAILED_plus#c.ROA_b 1.FAILED_plus#c.Mora_b 1.FAILED_plus#c.k_benchmark 1.FAILED_plus#c.COMMERCIAL"
qui eststo: reghdfe yy 1.FAILED_plus `interactions' `Controls_b' `Controls_fb', absorb(cod_titular) vce(cluster COD_GRUPO cod_titular)
	qui estadd local fe "Y", replace
	qui estadd local controls "Y", replace
	
#delimit ;
	esttab , 
	title(Table 7)
	drop(`Controls_b' `Controls_fb' _cons)
	collabels(none) 
	coeflabels(1.FAILED_plus "ST-Underperforming" 1.FAILED_plus#c.log_Assets_b " x Log(Assets)" 1.FAILED_plus#c.Liq_b " x Liquidity ratio" 1.FAILED_plus#c.ROA_b " x ROA" 1.FAILED_plus#c.Mora_b " x NPL ratio" 1.FAILED_plus#c.k_benchmark " x CT1R" 1.FAILED_plus#c.COMMERCIAL " x Commercial bank dummy")
	stats(controls fe N r2, fmt(%20s %20s %9.0fc %9.4f) labels("Controls" "Firm FE" "Observations" "R-squared"))
	b(%9.3f)  se(%9.3f) 
	 parentheses 
	star(* 0.10 ** 0.05 *** 0.01);
#delimit cr
eststo clear
********************************************************************************
* Table 8: Heterogeneous Effects on Credit Line/Relationship Characteristics
********************************************************************************
qui use CL_2011_6, clear
qui keep if DUP == 1
qui egen SUM_GRANTED = sum(GRANTED_t), by(cod_titular) 
qui xtile temp = SUM_GRANTED if temp_f == 1, n(2) 
qui egen GROUP_GRANTED_f = max(temp), by(cod_titular) // Two groups based on the size of the CL
qui drop temp
qui xtile GROUP_GRANTED_f_b = GRANTED_t, n(2) 

local Controls_fb = "SHARE PAST_DUE COLLATERALIZED SHORT_MATURITY USAGE"
local Controls_b  = "log_Assets_b Liq_b ROA_b COMMERCIAL Mora_b k_benchmark" 

local interactions = ""
local interaction_c = "c.COLLATERALIZED c.SHORT_MATURITY 1.PAST_DUE c.SHARE c.USAGE 2.GROUP_GRANTED_f_b"
foreach var_b in `interaction_c' {
	local inter = "1.FAILED_plus 1.FAILED_plus#`var_b'"
	qui eststo: reghdfe yy `inter' `Controls_b' `Controls_fb', absorb(cod_titular) vce(cluster COD_GRUPO cod_titular)
		qui estadd local fe "Y", replace
		qui estadd local controls "Y", replace
	local interactions = "`interactions'" + " 1.FAILED_plus#`var_b'"
	}	
	
qui eststo: reghdfe yy 1.FAILED_plus `interactions' `Controls_b' `Controls_fb', absorb(cod_titular) vce(cluster COD_GRUPO cod_titular)
	qui estadd local fe "Y", replace
	qui estadd local controls "Y", replace
	
#delimit ;
	esttab , 
	title(Table 8)
	drop(`Controls_b' `Controls_fb' _cons)
	collabels(none) 
	coeflabels(1.FAILED_plus "ST-Underperforming" 1.FAILED_plus#c.COLLATERALIZED "x Collateralized" 1.FAILED_plus#c.SHORT_MATURITY "x Short term maturity" 1.FAILED_plus#1.PAST_DUE "x Past due" 1.FAILED_plus#c.SHARE "x Share of credit line" 1.FAILED_plus#c.USAGE "x Initial usage rate" 1.FAILED_plus#2.GROUP_GRANTED_f_b "x 1(Granted>=P50)")
	stats(controls fe N r2, fmt(%20s %20s %9.0fc %9.4f) labels("Controls" "Firm FE" "Observations" "R-squared"))
	b(%9.3f)  se(%9.3f) 
	 parentheses 
	star(* 0.10 ** 0.05 *** 0.01);
#delimit cr
eststo clear
********************************************************************************
* Table 9: Heterogeneous Effects Based on Covenants
********************************************************************************
qui use CL_2011_6, clear
qui keep if DUP == 1 & Assets_f~= .

local Controls_fb = "SHARE PAST_DUE COLLATERALIZED SHORT_MATURITY USAGE"
local Controls_b  = "log_Assets_b Liq_b ROA_b COMMERCIAL Mora_b k_benchmark" 
	qui xtile temp = Cov_f if temp_f == 1, n(5) // 5 groups based on interest coverage ratio
	qui egen GROUP_ = max(temp), by(cod_titular) 

qui eststo: reghdfe yy 1.FAILED_plus#1.GROUP_ 1.FAILED_plus#2.GROUP_ 1.FAILED_plus#3.GROUP_ 1.FAILED_plus#4.GROUP_ 1.FAILED_plus#5.GROUP_ `Controls_b' `Controls_fb', absorb(cod_titular) vce(cluster COD_GRUPO cod_titular)
	qui estadd local fe "Y", replace
	qui estadd local controls "Y", replace
	drop temp GROUP_
	
	qui xtile temp = Cap_f if temp_f == 1, n(5) // 5 groups based on leverage
	qui egen GROUP_ = max(temp), by(cod_titular) 

qui eststo: reghdfe yy 1.FAILED_plus#1.GROUP_ 1.FAILED_plus#2.GROUP_ 1.FAILED_plus#3.GROUP_ 1.FAILED_plus#4.GROUP_ 1.FAILED_plus#5.GROUP_ `Controls_b' `Controls_fb', absorb(cod_titular) vce(cluster COD_GRUPO cod_titular)
	qui estadd local fe "Y", replace
	qui estadd local controls "Y", replace

#delimit ;
	esttab , 
	title(Table 9)
	drop(`Controls_b' `Controls_fb' _cons)
	collabels(none) 
	mtitle("Interest Coverage Ratio" "Leverage Ratio")
	nonumbers 
	stats(controls fe N r2, fmt(%20s %20s %9.0fc %9.4f) labels("Controls" "Firm FE" "Observations" "R-squared"))
	b(%9.3f)  se(%9.3f) 
	 parentheses 
	star(* 0.10 ** 0.05 *** 0.01)
	coeflabels(1.FAILED_plus#1.GROUP_ "Quintile 1" 1.FAILED_plus#2.GROUP_ "Quintile 2" 1.FAILED_plus#3.GROUP_ "Quintile 3" 1.FAILED_plus#4.GROUP_ "Quintile 4" 1.FAILED_plus#5.GROUP_ "Quintile 5") label;
#delimit cr
eststo clear
********************************************************************************
* Table 10: Expanding the sample to include firms with a credit line from a single bank
********************************************************************************	
qui use CL_2011_6, clear 

qui egen FIRM = group(cod_titular)
qui egen FE   = group(cod_provincia INDUSTRY_GROUPS SIZE)

qui gen FE_2 = FE
qui sum FE, meanonly
local max = r(max)
qui replace FE_2 = `max' + FIRM if DUP == 1 // Only if the firm has CLs with more than one bank, we shift the FE such that the "cluster" only includes the firm itself.

qui eststo: reghdfe yy FAILED_plus  log_Assets_b Liq_b ROA_b COMMERCIAL Mora_b k_benchmark   SHARE PAST_DUE COLLATERALIZED SHORT_MATURITY USAGE  if DUP == 1, absorb(cod_titular) vce(cluster COD_GRUPO cod_titular)
	qui estadd local controls "Y", replace
	qui estadd local fe "Y", replace
	qui estadd local clust "N", replace

qui eststo: reghdfe yy FAILED_plus  log_Assets_b Liq_b ROA_b COMMERCIAL Mora_b k_benchmark   SHARE PAST_DUE COLLATERALIZED SHORT_MATURITY USAGE, absorb(FE_2) vce(cluster COD_GRUPO cod_titular)
	qui estadd local controls "Y", replace
	qui estadd local fe "Y", replace
	qui estadd local clust "N", replace

qui eststo: reghdfe yy FAILED_plus 1.FAILED_plus##0.DUP log_Assets_b Liq_b ROA_b COMMERCIAL Mora_b k_benchmark SHARE PAST_DUE COLLATERALIZED SHORT_MATURITY USAGE, absorb(FE_2) vce(cluster COD_GRUPO cod_titular)
	qui estadd local controls "Y", replace
	qui estadd local fe "Y", replace
	qui estadd local clust "N", replace

#delimit ;
	esttab , replace
	title(Table 10)
	keep(FAILED_plus 1.FAILED_plus#0.DUP)
	collabels(none) 
	coeflabels(FAILED_plus "ST-Underperforming" 1.FAILED_plus#0.DUP " x Single-Bank")	
	label  stats(controls fe clust N r2, fmt(%20s %20s %20s %9.0fc %9.4f) labels("Controls" "Firm FE" "Firm-cluster FE" "Observations" "R-squared"))
	b(%9.3f)  se(%9.3f) 
	noabbrev nomtitle parentheses 
	star(* 0.10 ** 0.05 *** 0.01);
#delimit cr
eststo clear

********************************************************************************
********************************************************************************
********************************************************************************
********************************************************************************
********************************************************************************
********************************************************************************
*								APPENDIX
*_______________________________________________________________________________

********************************************************************************
*** 			APPENDIX B: EU STRESS TESTS & BANK STOCK PERFORMANCE
********************************************************************************
* Table B1: Effect of the 2011 EBA EU-wide Stress Test on Bank Stock Prices
********************************************************************************
use "Event Study", clear 
qui gen DUMMY = 0
qui replace DUMMY = 1 if adverse_12_s11 < 6
qui eststo: reg car_s11_2_1 DUMMY [aweight=weights_11]
qui eststo: reg car_3_s11   DUMMY [aweight=weights_11]

#delimit ;
	esttab , replace
	title(Table B1)
	keep(DUMMY)
	collabels(none) 
	coeflabels(DUMMY "ST-Underperforming")	
	label  stats(N r2, fmt(%9.0fc %9.3f) labels("Observations" "R-squared"))
	b(%9.3f)  se(%9.3f) 
	noabbrev nomtitle parentheses 
	star(* 0.10 ** 0.05 *** 0.01);
#delimit cr
eststo clear
/* In the first column, CARs are computed over the window Jul. 14 − Jul. 15, 2011, before the
results were announced. In the second column, CARs are computed over the window Jul. 18 − Jul. 20, 2011,
after the results were public (note that the stress tests results were released on Friday July 15, after markets
closed). The weights are calculated as the inverse of the root MSE from the one-factor model estimation
stage.*/ 
********************************************************************************
* Table B2: Effects of the 2010 and 2011 EBA EU-wide Stress Test on Bank Stock Prices
********************************************************************************	
qui gen distance = regulatory_S10
qui eststo:  reg car_s10_2_1 distance [aweight=weights_10]
qui eststo:  reg car_3_s10   distance [aweight=weights_10]
drop distance

qui gen distance = regulatory_S11
qui eststo:  reg car_s11_2_1 distance [aweight=weights_11]
qui eststo:  reg car_3_s11   distance [aweight=weights_11]

#delimit ;
	esttab , replace
	title(Table B2)
	keep(distance)
	collabels(none) 
	coeflabels(distance "Distance to regulatory ratio")	
	label  stats(N r2, fmt(%9.0fc %9.2f) labels("Observations" "R-squared"))
	b(%9.2f)  se(%9.2f) 
	noabbrev nomtitle parentheses 
	star(* 0.10 ** 0.05 *** 0.01);
#delimit cr
eststo clear
/* In the first and third column, CARs are computed over the window Jul. 22 − Jul.
23, 2010 and Jul. 14 − Jul. 15, 2011, respectively (before the release of the results). In the second and
fourth column, CARs are computed over the window Jul. 26 − Jul. 28, 2010 and Jul. 18 − Jul. 20, 2011,
respectively (after the release of the results). The weights are calculated as the inverse of the root MSE from
the one-factor model estimation stage.*/
********************************************************************************
*** 						APPENDIX C: ADDITIONAL TABLES
********************************************************************************
* Table C1: Descriptive Statistics
********************************************************************************	
quietly use CL_2011_5, replace
quietly replace yy = yy*100
tabstat yy if DUP == 1,stat(mean median sd N) format(%8.2f)
quietly use CL_2011_6, replace
quietly replace yy = yy*100
* 			PANEL A
tabstat yy PAST_DUE COLLATERALIZED SHORT_MATURITY SHARE USAGE if DUP == 1, c(stat) stat(mean median sd N) format(%8.2f)

use Bank_Fundamentals, clear
quietly replace ROA_b = ROA_b * 100
quietly replace Liq_b = Liq_b * 100
quietly replace Mora_b = Mora_b * 100
quietly replace k_benchmark = k_benchmark * 100
quietly replace UN_TO_ASSETS = UN_TO_ASSETS * 100
* 			PANEL B
tabstat FAILED_plus log_Assets_b ROA_b Liq_b Mora_b k_benchmark COMMERCIAL UN_TO_ASSETS [aw = Assets_b], c(stat) stat(mean median sd N) format(%8.2f)

quietly use CL_2011_6, replace
quietly egen No_CL = max(temp_f), by(cod_titular)
quietly sort cod_titular FAILED_plus
quietly by cod_titular FAILED_plus: gen temp_f1 = _n 
quietly replace ROA_f = ROA_f*100
quietly replace Liq1_f = Liq1_f*100
quietly replace Cap_f = Cap_f*100

* 			PANEL C
tabstat Assets_f Liq1_f Cap_f ROA_f RISK_CIR if DUP == 1 & temp_f1 == 1 & FAILED_plus == 1  & Assets_f~=., c(stat) stat(mean sd N) format(%10.3f)
tabstat Assets_f Liq1_f Cap_f ROA_f RISK_CIR if DUP == 1 & temp_f1 == 1 & FAILED_plus == 0  & Assets_f~=., c(stat) stat(mean sd N) format(%10.3f)
estimates clear
quietly keep if DUP == 1 & temp_f1 == 1 & Assets_f~=.
qui eststo: reg Assets_f 1.FAILED_plus, vce(robust)
qui eststo: reg Liq1_f 1.FAILED_plus, vce(robust)
qui eststo: reg Cap_f 1.FAILED_plus, vce(robust)
qui eststo: reg ROA_f 1.FAILED_plus, vce(robust)
qui eststo: reg RISK_CIR 1.FAILED_plus, vce(robust)
esttab , drop(_cons) star(* 0.10 ** 0.05 *** 0.01) stats(, ) b(%10.2f) se(%10.2f) nobaselevels
eststo clear

********************************************************************************
* Table C3: Effect of Performance in the Stress Test on Term Lending - Lending Relationships with Credit Lines in June 2011
********************************************************************************	
use Term_Lending_CL_clients, clear
/* The sample includes lending relationships with credit lines (the ones in Table 1 of the paper) that additionally had term lending balances. 
The dependent variable is the difference of the logarithm of the term loan amounts granted to
firm f by bank b over the selected period.*/ 
forval i=5(1)8 {
	local Controls_b    = "log_Assets_b Liq_b ROA_b COMMERCIAL Mora_b k_benchmark" 
	local Controls_fb   = "SHARE_`i' PAST_DUE_`i' COLLATERALIZED_`i' SHORT_MATURITY_`i'"
	local j = `i' + 1
	qui eststo: reghdfe CHANGE_`j'  1.FAILED_plus `Controls_b' `Controls_fb', absorb(cod_titular) vce(cluster COD_GRUPO cod_titular)
		qui estadd local fe "Y", replace
		qui estadd local controls "Y", replace	
}
forval i=5(1)8 {
	local Controls_b    = "log_Assets_b Liq_b ROA_b COMMERCIAL Mora_b k_benchmark" 
	local Controls_fb   = "SHARE_`i' PAST_DUE_`i' COLLATERALIZED_`i' SHORT_MATURITY_`i'"
	local j = `i' + 1

	qui eststo: reghdfe CHANGE_`j'  1.FAILED_plus##1.RUN `Controls_b' `Controls_fb', absorb(cod_titular) vce(cluster COD_GRUPO cod_titular)
		qui estadd local fe "Y", replace
		qui estadd local controls "Y", replace
	/*None of the linear combinations of the sum of the coefficient of
ST-Underperforming and its interaction with Run in columns 5 to 8 is statistically different from zero at
conventional significance levels*/	
	lincom 1.FAILED_plus + 1.FAILED_plus#1.RUN	
}

#delimit ;
	esttab ,
	title(Table 1)
	keep(1.FAILED_plus 1.FAILED_plus#1.RUN)
	collabels(none) 
	coeflabels(FAILED_plus "ST-Underperforming")
	label  stats(controls fe N r2, fmt(%20s %20s %9.0fc %9.4f) labels("Controls" "Firm FE" "Observations" "R-squared"))
	b(%9.3f)  se(%9.3f) 
	noabbrev nomtitle parentheses replace 
	star(* 0.10 ** 0.05 *** 0.01);
#delimit cr
eststo clear
	
********************************************************************************
* Table C4: Monthly change in the ratio of firms' deposits over bank assets
********************************************************************************	
* file Deposits.dta contains monthly data on sight and term deposits from NFC in Spain and in Euros. 
*Variable sight corresponds to sight deposits, variable term corresponds to term deposits. COD_GRUPO is a variable identifying each bank group, modate is a monthly date variable. log_Assets_b is the log of bank total assets
qui: use Deposits.dta, clear

describe

xtset COD_GRUPO modate

foreach varname of varlist sight term  {
gen `varname'Ass_chngpc=(`varname'-L.`varname')/exp(log_Assets_b)*100

}


foreach varname of varlist sight term   {
	
qui eststo: reghdfe `varname'Ass_chngpc FAILED_plus if modate==tm(2011-6) , cluster(COD_GRUPO)

qui eststo:  reghdfe `varname'Ass_chngpc FAILED_plus if modate==tm(2011-7) , cluster(COD_GRUPO)

qui eststo:  reghdfe `varname'Ass_chngpc FAILED_plus if modate==tm(2011-8) , cluster(COD_GRUPO)

qui eststo:  reghdfe `varname'Ass_chngpc FAILED_plus if modate==tm(2011-9) , cluster(COD_GRUPO)

}

#delimit ;
	esttab , title(Table C4) keep(FAILED_plus) collabels(none)	coeflabels(FAILED_plus "ST-Underperforming")
	label  stats( N r2, fmt(%9.0fc %9.3f) labels( "Observations" "R-squared"))
	b(%9.4f)  se(%9.4f) 
	nomtitle parentheses 
	star(* 0.10 ** 0.05 *** 0.01);
#delimit cr
eststo clear

********************************************************************************
* Table C5: Bank-level interest rate of credit line originated during July 2010 - June 2011
********************************************************************************
* File Int_rate.dta contains monthly bank-level data on interest rates on new credit lines in Spain, as well as yearly bank controls.
*Variable InterestRate corresponds to interest rates on new credit lines in Spain, aggreated at the bank-month level. Bank control variables are the same as in previous files

qui use "Int_rate.dta", clear

describe

local Controls_b  = "log_Assets_b Liq_b ROA_b COMMERCIAL Mora_b k_benchmark" 

qui eststo: reg InterestRate FAILED_plus if modate<tm(2011-7) & modate>tm(2010-6) , cluster(COD_GRUPO)
qui estadd local controls "N", replace
qui estadd local weight "N", replace
qui estadd local fe "N", replace

qui eststo: reg InterestRate FAILED_plus `Controls_b'  if modate<tm(2011-7) & modate>tm(2010-6) , cluster(COD_GRUPO)
qui estadd local controls "Y", replace
qui estadd local weight "N", replace
qui estadd local fe "N", replace

qui eststo: reg InterestRate FAILED_plus `Controls_b' if modate<tm(2011-7) & modate>tm(2010-6) [aw=Volume ], cluster(COD_GRUPO)
qui estadd local controls "Y", replace
qui estadd local weight "By Volumne", replace
qui estadd local fe "N", replace

qui eststo: reg InterestRate i.modate FAILED_plus `Controls_b'  if modate<tm(2011-7) & modate>tm(2010-6) , cluster(COD_GRUPO)
qui estadd local controls "Y", replace
qui estadd local weight "N", replace
qui estadd local fe "Y", replace

#delimit ;
	esttab , title(Table C5) keep(FAILED_plus _cons) collabels(none)	coeflabels(FAILED_plus "ST-Underperforming")
	label  stats(controls weight fe N r2, fmt(%20s %20s %20s %9.0fc %9.3f) labels("Bank Controls" "Weighted" "Month FE" "Observations" "R-squared"))
	b(%9.3f)  se(%9.3f) 
	nomtitle parentheses 
	star(* 0.10 ** 0.05 *** 0.01);
#delimit cr
eststo clear


********************************************************************************
* Table C6: Effect of the 2011 Stress Test on Usage Rate - Including Lines whose Granted Diminished
********************************************************************************
* This dataset includes all loan commitments with UNDRAWN funds > 0 (even those whose granted decayed between June and July) before we aggregate them at the bank and firm level. 
* Note: Main results are obtained when we keep CLs whose granted did not decay.

local Controls_fb = "SHARE PAST_DUE COLLATERALIZED SHORT_MATURITY USAGE"
local Controls_b  = "log_Assets_b Liq_b ROA_b COMMERCIAL Mora_b k_benchmark" 
	
qui use CL_2011_6_including_CLs_with_decreased_limit, clear
qui gen VAR_GRANTED = -100*(GRANTED_t1-GRANTED_t)/GRANTED_t 

foreach k in 0 40 80 100 {
preserve
	if `k'== 0 {
		qui keep if VAR_GRANTED == 0
	}
	if `k'!= 0 {
		qui drop if VAR_GRANTED >= `k' // We drop CLs that were downsized more that k%	
	}	
	* The following lines will be used to create COLLATERALIZED, SHORT_MATURITY
	* E.g., SHORT_MATURITY: % of the commitment that has a maturity <= 1y
	qui gen temp_Col = 0
	qui replace temp_Col = GRANTED_t if cod_garantia ~= "V" // No collateral
	qui gen temp_SM = 0
	qui replace temp_SM  = GRANTED_t if cod_plazo == "A" | cod_plazo == "B" // Maturity less than a year
	** We collapse by firm and bank
	qui collapse (sum) USED_t USED_t1 GRANTED_t GRANTED_t1 temp_Col temp_SM (max) PAST_DUE, by(cod_titular COD_GRUPO) 
	qui gen COLLATERALIZED = temp_Col / GRANTED_t
	qui gen SHORT_MATURITY = temp_SM / GRANTED_t
	qui egen TOTAL = total(GRANTED_t), by(cod_titular) // TOTAL granted (drawn + undrawn) funds via credit lines to firm f
	qui gen SHARE = GRANTED_t / TOTAL 
	qui gen USAGE = USED_t / GRANTED_t
	qui gen yy  = (USED_t1-USED_t)/GRANTED_t
	qui drop TOTAL temp_* 
	qui gen CAE = 0 
	qui replace CAE = 1 if GRANTED_t1 < GRANTED_t // Downsized dummy	
	qui merge m:1 COD_GRUPO using Bank_Fundamentals
	qui drop if _merge == 2 
	qui drop _merge
	
	qui eststo: reghdfe yy 1.FAILED_plus `Controls_b' `Controls_fb', absorb(cod_titular) vce(cluster COD_GRUPO cod_titular)
		qui estadd local fe "Y", replace
		qui estadd local controls "Y", replace
	if `k'!= 0 {	
	qui eststo: reghdfe yy 1.FAILED_plus 1.FAILED_plus#1.CAE CAE `Controls_b' `Controls_fb', absorb(cod_titular) vce(cluster COD_GRUPO cod_titular)
		qui estadd local fe "Y", replace
		qui estadd local controls "Y", replace
	}
	if `k'==100 {
		qui gen VAR_GRANTED = -(GRANTED_t1-GRANTED_t)/GRANTED_t 
		qui eststo: reghdfe yy 1.FAILED_plus 1.FAILED_plus#1.CAE 1.FAILED_plus#1.CAE#c.VAR_GRANTED CAE 1.CAE#c.VAR_GRANTED `Controls_b' `Controls_fb', absorb(cod_titular) vce(cluster COD_GRUPO cod_titular)
			qui estadd local fe "Y", replace
			qui estadd local controls "Y", replace	
	}
restore
}	

#delimit ;
	esttab , title(Table C6) 
	keep(1.FAILED_plus 1.FAILED_plus#1.CAE 1.FAILED_plus#1.CAE#c.VAR_GRANTED) 
	collabels(none)	
	coeflabels(1.FAILED_plus "ST-Underperforming")
	label  stats(controls fe N r2, fmt(%20s %20s %9.0fc %9.4f) labels("Controls" "Firm FE" "Observations" "R-squared"))
	b(%9.3f)  se(%9.3f) 
	nomtitle parentheses 
	star(* 0.10 ** 0.05 *** 0.01);
#delimit cr
eststo clear	
********************************************************************************
* Table C7: Effect of the 2011 Stress Test on Usage Rate - Different Samples of Banks
********************************************************************************
qui use CL_2011_6, clear
qui keep if DUP == 1

local Controls_fb  = "SHARE PAST_DUE COLLATERALIZED SHORT_MATURITY USAGE"
local Controls_b   = "log_Assets_b Liq_b ROA_b COMMERCIAL Mora_b k_benchmark" 
local Controls_b1  = "log_Assets_b Liq_b ROA_b COMMERCIAL Mora_b" 

forval i=1(1)7{
	qui eststo: reghdfe yy 1.FAILED_plus `Controls_b' `Controls_fb'  if SELECTION_ROBUSTEZ_`i' == 1, absorb(cod_titular) vce(cluster COD_GRUPO cod_titular)
		qui estadd local fe "Y", replace
		qui estadd local controls "Y", replace		
}

#delimit ;
	esttab , title(Table C7) keep(1.FAILED_plus) collabels(none)	coeflabels(1.FAILED_plus "ST-Underperforming")
	label  stats(controls fe N r2, fmt(%20s %20s %9.0fc %9.4f) labels("Controls" "Firm FE" "Observations" "R-squared"))
	b(%9.3f)  se(%9.3f) 
	nomtitle parentheses 
	star(* 0.10 ** 0.05 *** 0.01);
#delimit cr
eststo clear
*------------------------------------ (END) ------------------------------------
log close